<?php

namespace AminulBD\AlibabaCN\OpenAPI\Laravel;

use Illuminate\Http\Client\Response;
use Illuminate\Support\Facades\Http;

class Client
{
    /**
     * @var array
     */
    public $config;

    /**
     * @param array $config
     */
    public function __construct(array $config)
    {
        $fields = ['id', 'secret', 'token', 'endpoint'];
        foreach ($fields as $field) {
            if (empty($config[$field])) {
                throw new \InvalidArgumentException("$field is required");
            }
        }

        $this->config = $config;
    }

    /**
     * Generate signature for given data.
     *
     * @param string $api
     * @param array $data
     *
     * @return string
     */
    private function signature(string $api, array $data = []): string
    {
        $params = [];
        foreach ($data as $key => $val) {
            $params[] = $key . $val;
        }
        sort($params);

        $params = join('', $params);
        $str = $api . $params;

        return strtoupper(bin2hex(hash_hmac('sha1', $str, $this->config['secret'], true)));
    }

    /**
     * @param string $api
     * @param array $data
     *
     * @return \Illuminate\Http\Client\Response
     * @throws \Illuminate\Http\Client\ConnectionException
     */
    public function request(string $api, array $data = []): Response
    {
        $api = trim($api, '/');
        $api = "param2/1/$api/{$this->config['id']}";
        $data['access_token'] = $this->config['token'];
        $data['_aop_timestamp'] = time() * 1000;
        $signature = $this->signature($api, $data);
        $baseUrl = rtrim($this->config['endpoint'], '/');

        return Http::baseUrl($baseUrl)
            ->asForm()
            ->post($api, array_merge(
                $data,
                ['_aop_signature' => $signature]
            ));
    }
}
