# Alibaba (1688.com) OpenAPI SDK for Laravel

Use this SDK to integrate Alibaba OpenAPI services with your Laravel application.

## Installation

You can install the package via composer:

```bash
composer require aminulbd/laravel-alibabacn-openapi
```

## Configuration

Use the following .env variables to configure the SDK:

```bash
ALIBABACN_OPENAPI_APP_ID=
ALIBABACN_OPENAPI_APP_SECRET=
ALIBABACN_OPENAPI_ACCESS_TOKEN=
```

## How to use

Read the documentation here: [open.1688.com](https://open.1688.com/solution/solutionDetail.htm?solutionKey=1697015659372)

Here is example usage of `product.search.keywordQuery` API:

```php
use AminulBD\AlibabaCN\OpenAPI\Laravel\Facades\AlibabaOpenAPI;

$api = 'com.alibaba.fenxiao.crossborder/product.search.keywordQuery';
$data = [
    'offerQueryParam' => json_encode([
        'keyword' => 'Shoes',
        'beginPage' => 1,
        'pageSize' => 20,
        'country' => 'en',
        'keywordTranslate' => false,
    ]),
];

$response = AlibabaOpenAPI::request($api, $data); // returns \Illuminate\Http\Client\Response

dd($response->json());
```
