<?php

namespace AminulBD\AlibabaCN\OpenAPI\Laravel;

use Illuminate\Support\ServiceProvider;

class AlibabaCNOpenAPIServiceProvider extends ServiceProvider
{
    /**
     * Register the package services.
     *
     * @return void
     * @throws \Exception
     */
    public function register()
    {
        if (!app()->configurationIsCached()) {
            $this->mergeConfigFrom(__DIR__ . '/../config/alibabacn.php', 'alibabacn');
        }

        $this->app->singleton(Client::class, function () {
            $config = config('alibabacn');

            return new Client($config);
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        if (app()->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/../config/alibabacn.php' => config_path('alibabacn.php'),
            ], 'alibabacn-config');
        }
    }
}
