# AliExpress OpenAPI SDK for Laravel

Use this SDK to integrate AliExpress OpenAPI services with your Laravel application.

## Installation

You can install the package via composer:

```bash
composer require aminulbd/aliexpress-laravel
```

## Configuration

Use the following .env variables to configure the SDK:

```bash
ALIEXPRESS_APP_KEY=
ALIEXPRESS_APP_SECRET=
ALIEXPRESS_REDIRECT_URI=https://yourdomain.com/aliexpress-callback
```

## How to use

Read the documentation here: [openservice.aliexpress.com](https://openservice.aliexpress.com/)

```php
<?php

use AminulBD\AliExpress\Laravel\AliExpress;
use Illuminate\Support\Facades\Route;


Route::get('/login', function() {
    return redirect(AliExpress::getAuthorizeUrl());
});

Route::get('/authorize', function() {
    $code = request()->query('code');

    if(empty($code)) {
        return [
            'error' => 'Authorization code is missing.',
            'message' => 'Please authorize the application to get the access token.'
        ];
    }

    return AliExpress::getAccessToken($code)->json();
});

Route::get('/refresh', function() {
    $token = 'your-refresh-token-here'; // Replace with your refresh token. Maybe from cache or DB
    $response = AliExpress::refreshAccessToken($token);

    return $response->json();
});

Route::get('/search', function() {
    $keyword = request()->query('keyword');
    $token = 'your-auth-token-here'; // Replace with your refresh token. Maybe from cache or DB
    $response = AliExpress::request('aliexpress.ds.text.search', [
        'access_token' => $token,
        'keyWord' => $keyword,
        'local' => "en_US",
        'countryCode' => "BD",
        'currency' => "USD",
        'pageSize' => 20,
        'pageIndex' => 1,
    ]);

    return $response->json();
});

```
