<?php

namespace AminulBD\AliExpressOpenService\Laravel;

use Illuminate\Support\ServiceProvider;

class AliExpressOpenServiceProvider extends ServiceProvider
{
    /**
     * Register the package services.
     *
     * @return void
     * @throws \Exception
     */
    public function register()
    {
        if (!app()->configurationIsCached()) {
            $this->mergeConfigFrom(__DIR__ . '/../config/aliexpress.php', 'aliexpress');
        }

        $this->app->singleton(Client::class, function () {
            $config = config('aliexpress');

            return new Client($config);
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        if (app()->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/../config/aliexpress.php' => config_path('aliexpress.php'),
            ], 'aliexpress-config');
        }
    }
}
