<?php

namespace AminulBD\Offlentory\Engine;

use Symfony\Component\HttpClient\HttpClient;
use Symfony\Contracts\HttpClient\HttpClientInterface;

class AliExpress implements Engine
{
    protected array $headers = [
        'Content-Type' => 'application/json',
        'Accept' => 'application/json',
        'User-Agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36',
        'Cookie' => 'aep_usuc_f=site=glo&c_tp=USD&b_locale=en_US;'
    ];

    protected array $options = [
        'timeout' => 30,
    ];

    protected HttpClientInterface $http;

    public function __construct(array $options = [])
    {
        $this->options = array_merge($this->options, $options ?? []);
        $this->options['headers'] = array_merge($this->headers, $this->options['headers'] ?? []);

        $this->http = HttpClient::create($this->options);
    }

    public function search(array $filters = [], array $options = []): array
    {
        $search = $filters['q'] ?? null;
        $page = $options['page'] ?? 1;
        $limit = $options['limit'] ?? 20;
        $sort = $options['sort'] ?? 'total_tranpro_desc'; // total_tranpro_desc, total_tranpro_asc, price_asc, price_desc,

        if (!$search) {
            return [];
        }

        $params = [
            'target' => 'root',
            'eventName' => 'onChange',
            'dependency' => [],
            'data' => [
                'SearchText' => $search,
                'catId' => '0',
                // 'CatId' => '0',
                'page' => $page,
                'pageSize' => $limit,
                'sortType' => 'total_tranpro_desc',
                'origin' => 'y',
                'g' => 'y',
                'trafficChannel' => 'main',
            ]
        ];

        $url = 'https://www.aliexpress.com/fn/search-pc/index';
        $response = $this->http->request('POST', $url, [
            'body' => json_encode($params),
        ]);

        if ($response->getStatusCode() !== 200) {
            return [];
        }

        $data = json_decode($response->getContent(), true);

        return [
            'items' => $this->parseItems($data),
            'filters' => $this->parseFilters($data),
            'sorter' => $this->parseSorter($data),
            'pagination' => [
                'total' => ofl_data_get($data, 'data.result.pageInfo.totalResults'),
                'limit' => ofl_data_get($data, 'data.result.pageInfo.pageSize'),
                'page' => ofl_data_get($data, 'data.result.pageInfo.page'),
            ],
        ];
    }

    public function freights(array $params = []): array
    {
        return [];
    }

    public function details(array $params = []): array
    {
        return [];
    }

    public function content(array $params = []): ?string
    {
        return '';
    }

    /**
     * Parse items from response.
     *
     * @param $data
     *
     * @return array
     */
    private function parseItems($data): array
    {
        $products = ofl_data_get($data, 'data.result.mods.itemList.content', []);
        $products = array_map(function ($item) {
            if (!isset($item['productId'])) {
                return null;
            }

            $regular = ofl_data_get($item, 'prices.originalPrice.minPrice');
            $discount = ofl_data_get($item, 'prices.salePrice.discount');
            $sale = ofl_data_get($item, 'prices.salePrice.minPrice');

            if (!$regular && $sale && $discount) {
                $regular = ofl_original_price($sale, $discount);
            } elseif (!$regular) {
                $regular = $sale;
            }

            $shipping = null;
            $sellingPoints = ofl_data_get($item, 'sellingPoints', []);
            foreach ($sellingPoints as $point) {
                if ($point['source'] === 'Shipping_Fee_atm') {
                    $shipping = (float)str_replace('+Shipping: US $', '', $point['tagContent']['tagText']);
                    break;
                }
            }

            $image = ofl_fix_url(ofl_data_get($item, 'image.imgUrl'));

            return [
                'id' => $item['productId'],
                'title' => ofl_data_get($item, 'title.displayTitle'),
                'price' => [
                    'discount' => $discount,
                    'regular' => [
                        'min' => $regular,
                        'max' => null
                    ],
                    'sale' => [
                        'min' => $sale === $regular ? null : $sale,
                        'max' => null,
                    ],
                    // TODO: add when pre-order is available
                    'preorder' => [
                        'min' => null,
                        'max' => null
                    ],
                    'shipping' => [
                        'international' => $shipping,
                        'domestic' => null,
                    ],
                ],
                'rating' => [
                    'count' => null,
                    'average' => ofl_data_get($item, 'evaluation.starRating'),
                    'max' => 5,
                ],
                'image' => $image,
                'image_full' => str_replace('_220x220xz.jpg', '', $image),
                'url' => 'https://www.aliexpress.com/item/' . $item['productId'] . '.html',
                'store' => [
                    'id' => ofl_data_get($item, 'store.storeId'),
                    'member_id' => ofl_data_get($item, 'store.aliMemberId'),
                    'name' => ofl_data_get($item, 'store.storeName'),
                    'url' => ofl_fix_url(ofl_data_get($item, 'store.storeUrl')),
                ],
                'created_at' => $item['lunchTime'] ?? null,
                'sold' => (int)preg_replace('/[^0-9]/', '', ofl_data_get($item, 'trade.tradeDesc', '')) ?? null,
                'updated_at' => null,
            ];
        }, $products);

        return array_filter($products);
    }

    private function parseFilters($data): array
    {
        return [];
    }

    private function parseSorter($data): array
    {
        return [
            '' => 'Best Match',
            'total_tranpro_desc' => 'Most Popular',
            'total_tranpro_asc' => 'Least Popular',
            'price_asc' => 'Price: Low to High',
            'price_desc' => 'Price: High to Low',
        ];
    }
}
