<?php

namespace AminulBD\Offlentory;

use AminulBD\Offlentory\Engine\AliExpress;
use AminulBD\Offlentory\Engine\Engine;

final class Offlentory
{
    private static array $engines = [
        'aliexpress' => AliExpress::class,
    ];

    private static array $customEngines = [];

    public Engine $engine;

    /**
     * @throws \Exception
     */
    public function __construct(string $engine, ...$args)
    {
        $engines = self::$customEngines + self::$engines;

        if (isset($engines[$engine])) {
            $this->engine = new $engines[$engine](...$args);
        } else {
            throw new \Exception("The Engine `$engine` is not supported.");
        }
    }

    public static function register(string $name, string $engine): void
    {
        self::$customEngines[$name] = $engine;
    }
}
