<?php


function ofl_data_get($data, $key, $default = null)
{
    if (is_null($key)) {
        return $data;
    }

    if (isset($data[$key])) {
        return $data[$key];
    }

    foreach (explode('.', $key) as $segment) {
        if (is_array($data) && array_key_exists($segment, $data)) {
            $data = $data[$segment];
        } else {
            return $default;
        }
    }

    return $data;
}

/**
 * Fix non-proto url
 *
 * @param mixed $url
 *
 * @return mixed
 */
function ofl_fix_url($url)
{
    if (strpos($url, '//') === 0) {
        $url = 'https:' . $url;
    }

    return $url;
}

/**
 * @param float|int $price
 * @param float|int $discount
 *
 * @return float
 */
function ofl_discount_price($price, $discount)
{
    return (float) number_format($price - ($price * $discount / 100), '2', '.', '');
}

/**
 * @param float|int $price
 * @param float|int $discount
 *
 * @return float
 */
function ofl_original_price($price, $discount): float
{
    return (float) number_format($price / (1 - $discount / 100), '2', '.', '');
}
