# Streams

The php library to get streams from different sources.

## Installation

Add this to your composer.json file.
```json
{
  "repositories": [{
    "type": "composer",
    "url": "https://composer.packages.moveon.work"
  }]
}
```

Then run this command in your terminal within your project directory.
```bash
composer require aminulbd/streams
```

## Usage

```php
use AminulBD\Streams\Streams;

$streams = new Streams('1688');

// get categories
$categories = $streams->engine->categories();

// get default feed (live)
$default = $streams->engine->feed([
    // 'feedType' => 'live', // [optional] live, upcoming, playback and category. default: live
    // 'categoryId' => 1234, // [optional] filter by category id. Hint: Get the category id from categories method or `category` feedType `feed` method.
    // 'limit' => 20,
    // 'page' => 1,
    // ...all other params available in the origin api.
]);

// These methods are alias of feed method
// get live streams
$live = $streams->engine->live([
    'feedType' => 'live',
    //... all other params available in the `feed` method.
]);

// get upcoming streams
$upcoming = $streams->engine->upcoming([
    'feedType' => 'upcoming',
    //... all other params available in the `feed` method.
]);

// get past streams
$past = $streams->engine->playback([
    'feedType' => 'playback',
    //... all other params available in the `feed` method.
]);

// get past streams of a specific user
$past = $streams->engine->history([
    'streamerId' => '12345',
    //... all other params available in the `feed` method.
]);

// get stream details
$details = $streams->engine->details([
    'feedId' => '12345',
]);

// get offers of a stream
$offers = $streams->engine->offers([
    'streamerId' => 8805858,
    'loginId' => '依恩佳美服饰',
    'feedId' => '427482760848',
]);
```
