<?php

namespace AminulBD\Streams;

use AminulBD\Streams\Engine\Alibaba1688;
use AminulBD\Streams\Engine\Engine;

final class Streams
{
    private static array $engines = [
        '1688' => Alibaba1688::class,
    ];

    private static array $customEngines = [];

    public Engine $engine;

    /**
     * @throws \Exception
     */
    public function __construct(string $engine, ...$args)
    {
        $engines = self::$customEngines + self::$engines;

        if (isset($engines[$engine])) {
            $this->engine = new $engines[$engine](...$args);
        } else {
            throw new \Exception("The Engine `$engine` is not supported.");
        }
    }

    public static function register(string $name, string $engine): void
    {
        self::$customEngines[$name] = $engine;
    }
}
