# Streams

The php library to get streams from different sources.

## Installation

Add this to your composer.json file.
```json
{
  "repositories": [{
    "type": "composer",
    "url": "https://composer.packages.moveon.work"
  }]
}
```

Then run this command in your terminal within your project directory.
```bash
composer require aminulbd/streams
```

## Usage

```php
use AminulBD\Streams\Streams;

$streams = new Streams('1688');

// get live streams
$live = $streams->engine->live();

// get upcoming streams
$upcoming = $streams->engine->upcoming();

// get past streams
$past = $streams->engine->playback();

// get categories
$categories = $streams->engine->categories();

// switch categories
$streams->engine->byCategory('12345');

// now you can call `->live()`, `->upcoming()` and `->playback()` to get streams
```
