# Taobao SDK for Laravel

Use this SDK to integrate Taobao with your Laravel application.

## Installation

You can install the package via composer:

```bash
composer require aminulbd/taobao-laravel
```

## Configuration

Use the following .env variables to configure the SDK:

```bash
TAOBAO_APP_KEY=
TAOBAO_APP_SECRET=
TAOBAO_REDIRECT_URI=https://yourdomain.com/taobao-callback
```

## How to use

Read the documentation here: [open.taobao.global](https://open.taobao.global/doc/api.htm)

```php
<?php

use AminulBD\Taobao\Laravel\Taobao;

// Redirect user to this URL to authorize your app
$authUrl = Taobao::getAuthorizeUrl();

// After user authorizes, they will be redirected to your redirect URI with a code
$code = request()->query('code');
$getAccessToken = Taobao::getAccessToken($code)->json();

// Refresh the access token using the refresh token
$refreshToken = $getAccessToken['refresh_token'];
$getAccessToken = Taobao::refreshAccessToken($refreshToken)->json();


// Product search
$params = [
    'access_token' => '', // Obtained from `Taobao::getAccessToken($code)`. make sure you have cached it till expired.
    'keyword' => 'bag',
    'page_no' => 1,
    'page_size' => 20,
    'language' => 'en',
];

$data = Taobao::request('/traffic/item/search', $params)->json();

// Product details
$itemId = $request->get('id');
$params = [
    'access_token' => '', // Obtained from `Taobao::getAccessToken($code)`. make sure you have cached it till expired.
    'item_id' => '797179021743',
    'item_resource' => 'taobao',
    'language' => 'en',
];

$data = Taobao::request('/traffic/item/get', $params)->json();
```
