<?php

namespace AminulBD\Taobao\Laravel;

use Illuminate\Support\ServiceProvider;

class TaobaoServiceProvider extends ServiceProvider
{
    /**
     * Register the package services.
     *
     * @return void
     * @throws \Exception
     */
    public function register()
    {
        if (!app()->configurationIsCached()) {
            $this->mergeConfigFrom(__DIR__ . '/../config/taobao.php', 'taobao');
        }

        $this->app->singleton(Client::class, function () {
            $config = config('taobao');

            return new Client($config);
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        if (app()->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/../config/taobao.php' => config_path('taobao.php'),
            ], 'taobao-config');
        }
    }
}
