# Cartay

The package will do all automation job for shop like `1688`, `taobao`, `aliexpress` etc.

## How to use?

#### Add Repository to your composer.json file

```json
"repositories": [
    {
        "type": "composer",
        "url": "https://composer.packages.moveon.work"
    }
],
```

Now, install this package by running the `composer require moveon/cartay` in your project directory.

Now you have to implement the `MoveOn\Cartay\Contracts\Account` interface to your model.

### Example:

```php
use MoveOn\Cartay\Cartay;
use MoveOn\Cartay\Contracts\Account;
use MoveOn\Cartay\Helpers\CookieManager;

class Model implements Account
{
    public function getAccountId(): string
    {
        return '123456';
    }

    public function getDriver(): string
    {
        return 'alibaba1688'; // See available drivers in `MoveOn\Cartay\Drivers`
    }

    public function getHeaders(): array
    {
        return [
            'Referrer' => 'https://detail.1688.com',
        ];
    }

    public function getCookies(): array
    {
        return [
            'session_value' => 'FGHJKDFGHJKHBNHBNKMNBNM'
        ];
    }

    public function getOptions(): array
    {
        return [
            'x-api-token' => 'some-random-value'
        ];
    }
}

$account = new Model();
$driver = new Cartay($account);

// Get cart items.
$driver->cart()->toArray();

// Remove from the cart
$driver->remove('12345697755');

// Update on the cart
$driver->update('3180139787698', ['quantity' => 5]);

$driver->update('3180139787698', ['shipping' => 'DHL']); // for aliexpress only.

// Add to cart
$link = 'https://detail.1688.com/offer/123456789.html';
$skus = [
  	['id' => '123658995', 'qty' => 20]
];
$driver->add($link, $skus);

// Get Orders
$page = 1;
$orderFilter = [];
$driver->orders($page, $orderFilter)->toArray();

// Get Tracking of order
$driver->tracking('1980129098149634102')->toArray();

// Clear cookies
CookieManager::clearCookies($account);
```

## Custom driver needed?

```php

use MoveOn\Cartay\Drivers\Driver;
use MoveOn\Cartay\Cartay;

class AGreatDriver extends Driver
{
    /**
     * The cart.
     *
     * @return \MoveOn\Cartay\Cart
     */
    public function cart(): Cart
    {
        // Get cart logic here.
        
        $this->cart->setStatus(
            'success',
            'Cart items are fetched.'
        );

        return $this->cart;
    }

    /**
     * Add item to the cart.
     *
     * $skus = [
     *     ['id' => '1234', 'qty' => 3]
     * ]
     *
     * @param string $link
     * @param array $skus
     *
     * @return bool
     * @throws \MoveOn\Cartay\Exceptions\CartayException
     */
    public function add(string $link, array $skus): bool
    {
        // Add logic here.
    }

    /**
     * Update cart item.
     *
     * Example for $params: ['quantity' => 1]
     *
     * @param string $itemId
     * @param array $params
     *
     * @return bool
     * @throws \MoveOn\Cartay\Exceptions\CartayException
     */
    public function update(string $itemId, array $params): bool
    {
        // Update logic here.
    }

    /**
     * Remove item from the cart.
     *
     * @param string $itemId
     *
     * @return bool
     * @throws \MoveOn\Cartay\Exceptions\CartayException
     */
    public function remove(string $itemId): bool
    {
        // Remove logic here.
    }
}

// Register it on your project (For laravel, use AppServiceProvider)
Cartay::registerCustomDrivers([
    'agreatdriver' => '\SomeVendor\Shop\AGreatDriver',
]);
```

## TODO

- [x] Write tests.
- [x] All Shop Tracking
- [x] AliExpress
- [x] Taobao / Tmall
- [x] 1688 (Alibaba China)
- [ ] Gearbest
- [ ] Amazon
- [ ] Improve code quality (ie: duplicate code, messy cart item filter)
- [ ] Remove duplicate methods from `Cartay.php` and use `__call`
- [ ] Guzzle Client Extraction and Option.
