<?php

namespace MoveOn\Cartay;

class Orders
{
    /**
     * @var string|null
     */
    public ?string $status = null;

    /**
     * @var string|null
     */
    public ?string $message = null;

    /**
     * @var array
     */
    protected array $items = [];

    /**
     * @var int
     */
    public int $pageCount = 1;

    /**
     * @var int
     */
    public int $currentPage = 1;

    /**
     * Add item to the orders.
     *
     * @param \MoveOn\Cartay\OrderItem $item
     */
    public function add(OrderItem $item): void
    {
        $this->items[] = $item->toArray();
    }

    /**
     * Get cart items.
     *
     * @return array
     */
    public function getItems(): array
    {
        return $this->items;
    }

    /**
     * Set cart status.
     *
     * @param string $status
     * @param string $message
     */
    public function setStatus(string $status, string $message): void
    {
        $this->status  = $status;
        $this->message = $message;
    }

    /**
     * Get the instance as an array.
     *
     * @return array
     */
    public function toArray(): array
    {
        return [
            'status'       => $this->status,
            'message'      => $this->message,
            'items'        => $this->items,
            'current_page' => $this->currentPage,
            'page_count'   => $this->pageCount,
        ];
    }
}
