<?php

namespace MoveOn\Cartay;

use ArrayAccess;

class Tracking implements ArrayAccess
{
    /**
     * @var string|null
     */
    private ?string $code;

    /**
     * @var string|null
     */
    private ?string $status;

    /**
     * @var string|null
     */
    private ?string $message;

    /**
     * @var array
     */
    private array $attributes = [];

    /**
     * Tracking constructor.
     *
     * @param string|null $code
     * @param string|null $status
     * @param string|null $message
     */
    public function __construct(?string $code = null, ?string $status = null, ?string $message = null)
    {
        $this->code    = $code;
        $this->status  = $status;
        $this->message = $message;
    }

    /**
     * @param string|null $code
     */
    public function setCode(?string $code)
    {
        $this->code = $code;
    }

    /**
     * Get code.
     *
     * @return string|null
     */
    public function getCode(): ?string
    {
        return $this->code;
    }

    /**
     * Set Status and Message.
     *
     * @param string $status
     * @param string|null $message
     */
    public function setStatus(string $status, ?string $message = null)
    {
        $this->status = $status;

        if ($message) {
            $this->message = $message;
        }
    }

    /**
     * Set Message.
     *
     * @param string $message
     */
    public function setMessage(string $message)
    {
        $this->message = $message;
    }

    /**
     * Set attributes.
     *
     * @param array $attributes
     */
    public function setAttributes(array $attributes)
    {
        $this->attributes = array_merge($this->attributes, $attributes);
    }

    /**
     * Get a field value.
     *
     * @param $name
     * @param $value
     */
    public function __set($name, $value)
    {
        $this->attributes[$name] = $value;
    }

    /**
     * Set a field value.
     *
     * @param $name
     *
     * @return mixed|null
     */
    public function __get($name)
    {
        return $this->attributes[$name] ?? null;
    }

    /**
     * Get the instance as an array.
     *
     * @return array
     */
    public function toArray(): array
    {
        return [
            'status'     => $this->status,
            'message'    => $this->message,
            'tracking'   => $this->code,
            'attributes' => $this->attributes,
        ];
    }

    /**
     * If field exists.
     *
     * @param mixed $offset
     *
     * @return bool
     */
    public function offsetExists($offset): bool
    {
        return isset($this->attributes[$offset]);
    }

    /**
     * Get attribute.
     *
     * @param mixed $offset
     *
     * @return mixed|void
     */
    public function offsetGet($offset)
    {
        return $this->attributes[$offset] ?? null;
    }

    /**
     * Set attribute.
     *
     * @param mixed $offset
     * @param mixed $value
     */
    public function offsetSet($offset, $value)
    {
        $this->attributes[$offset] = $value;
    }

    /**
     * Unset attribute.
     *
     * @param mixed $offset
     */
    public function offsetUnset($offset)
    {
        unset($this->attributes[$offset]);
    }
}
