<?php

namespace MoveOn\Cartay;

class Cart
{
    /**
     * @var string|null
     */
    public ?string $status = null;

    /**
     * @var string|null
     */
    public ?string $message = null;

    /**
     * @var array
     */
    protected array $items = [];

    /**
     * @var int
     */
    public int $limit = 0;

    /**
     * add item to the cart.
     *
     * @param \MoveOn\Cartay\CartItem $item
     */
    public function add(CartItem $item): void
    {
        $this->items[] = $item->toArray();
    }

    /**
     * Get cart items.
     *
     * @return array
     */
    public function getItems(): array
    {
        return $this->items;
    }

    /**
     * Set cart status.
     *
     * @param string $status
     * @param string $message
     */
    public function setStatus(string $status, string $message): void
    {
        $this->status  = $status;
        $this->message = $message;
    }

    /**
     * Get the instance as an array.
     *
     * @return array
     */
    public function toArray(): array
    {
        return [
            'status'  => $this->status,
            'message' => $this->message,
            'limit'   => $this->limit,
            'items'   => $this->items,
        ];
    }
}
