<?php

namespace MoveOn\Cartay\Contracts;

use MoveOn\Cartay\Cart;
use MoveOn\Cartay\Orders;
use MoveOn\Cartay\Tracking;

interface Driver
{
    /**
     * The cart.
     *
     * @return \MoveOn\Cartay\Cart
     */
    public function cart(): Cart;

    /**
     * Add item to the cart.
     *
     * $skus = [
     *     ['id' => '1234', 'qty' => 3]
     * ]
     *
     * @param string $link
     * @param array $skus
     *
     * @return bool
     * @throws \MoveOn\Cartay\Exceptions\CartayException
     */
    public function add(string $link, array $skus): bool;

    /**
     * Update cart item.
     *
     * Example for $params: ['quantity' => 1]
     *
     * @param string $itemId
     * @param array $params
     *
     * @return bool
     * @throws \MoveOn\Cartay\Exceptions\CartayException
     */
    public function update(string $itemId, array $params): bool;

    /**
     * Remove item from the cart.
     *
     * @param string $itemId
     *
     * @return bool
     * @throws \MoveOn\Cartay\Exceptions\CartayException
     */
    public function remove(string $itemId): bool;

    /**
     * Get orders.
     *
     * @param int $page
     * @param array $filters
     *
     * @return \MoveOn\Cartay\Orders
     */
    public function orders(int $page = 1, array $filters = []): Orders;

    /**
     * Get tracking by Order ID.
     *
     * @param string $orderId
     * @param array $params
     *
     * @return \MoveOn\Cartay\Tracking
     */
    public function tracking(string $orderId, array $params = []): Tracking;
}
