<?php

use MoveOn\Cartay\Cartay;
use MoveOn\Cartay\Contracts\Account;
use MoveOn\Cartay\Helpers\CookieManager;

require_once __DIR__ . '/../vendor/autoload.php';

class Model implements Account
{
    public function getAccountId(): string
    {
        return '123456';
    }

    public function getDriver(): string
    {
        return 'aliexpress'; // See available drivers in `MoveOn\Cartay\Drivers`
    }

    public function getHeaders(): array
    {
        return [
            'Referrer' => 'https://www.aliexpress.com',
        ];
    }

    public function getCookies(): array
    {
        $cookies = file_get_contents(__DIR__ . '/cookies.aliexpress.txt');
        $cookies = CookieManager::parse($cookies, '.aliexpress.com');

        return array_column($cookies, 'Value', 'Name');
    }

    public function getOptions(): array
    {
        return [];
    }
}

$account = new Model();
$driver = new Cartay($account);

// CookieManager::clearCookies($account);

// Get cart items.
$items = $driver->cart()->toArray();
print_r($items);

// // Remove from the cart
// $driver->remove('12345697755');

// // Update on the cart
// $driver->update('3180139787698', ['quantity' => 5]);

// $driver->update('3180139787698', ['shipping' => 'DHL']); // for aliexpress only.

// // Add to cart
// $link = 'https://detail.1688.com/offer/123456789.html';
// $skus = [
//   	['id' => '123658995', 'qty' => 20]
// ];
// $driver->add($link, $skus);

// Get Orders
// $page = 1;
// $orderFilter = [];
// $driver->orders($page, $orderFilter)->toArray();

// // Get Tracking of order
// $driver->tracking('1980129098149634102')->toArray();

// // Clear cookies
// CookieManager::clearCookies($account);
