<?php

namespace MoveOn\Cartay\Contracts;

interface Account
{
    /**
     * Get account unique id.
     *
     * @return string
     */
    public function getAccountId(): string;

    /**
     * Get the driver class name.
     *
     * @return string
     */
    public function getDriver(): string;

    /**
     * Get all headers in key-value pairs.
     *
     * Example: ['Header-Name' => 'HeaderValue']
     *
     * @return array
     */
    public function getHeaders(): array;

    /**
     * Cookies as array.
     *
     * Example: ['CookieName' => 'CookieValue']
     *
     * @return array
     */
    public function getCookies(): array;

    /**
     * Options is available for the account.
     *
     * Example: ['timeout' => 40, 'epn_hash' => 'abc']
     *
     * @return array
     */
    public function getOptions(): array;
}
