<?php

namespace MoveOn\Cartay\Tests;

use Mockery;
use MoveOn\Cartay\Cartay;
use MoveOn\Cartay\Contracts\Account;
use PHPUnit\Framework\TestCase;

class DriverFeatureTest extends TestCase
{
    public function test_can_register_custom_drivers()
    {
        $factory = Mockery::mock(Account::class);
        $factory->shouldReceive('getDriver')
            ->andReturn('alibaba1688');

        $factory->shouldReceive('getHeaders')
            ->andReturn([]);

        $factory->shouldReceive('getCookies')
            ->andReturn([]);

        $factory->shouldReceive('getAccountId')
            ->andReturn('1');

        Cartay::registerCustomDrivers([
            'testdriver' => '\Example\TestDriver',
        ]);

        $data = new Cartay($factory);

        $this->assertArrayHasKey('testdriver', $data->getAllDrivers());
    }
}
