<?php

namespace MoveOn\Common\Traits;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use MoveOn\Common\Modules\QueryFilter;

/**
 * @method static filter(QueryFilter|string $filter, ?Request $request = null)
 */
trait Filterable
{
    /**
     * Filter a result set.
     *
     * @param Builder $query
     * @param QueryFilter $filters
     * @return Builder
     */
    public function scopeFilter(Builder $query, QueryFilter|string $filter, ?Request $request = null)
    {
        if ($filter instanceof \MoveOn\Common\Contracts\QueryFilterContract) {
            if (empty($request)) {
                return $filter->apply($query);
            }
            return $filter->setRequest($request)->apply($query);
        }

        $filter = new $filter($request ?? request());
        return $filter->apply($query);
    }
}