<?php

namespace MoveOn\Common\Traits;

trait BaseEnum
{

    public static function __callStatic($name, $args)
    {
        $cases = static::getCases();
        foreach ($cases as $case) {
            if ($case->name === $name) {
                return $case->value;
            }
        }

        return null;
    }

    public static function values(): array
    {
        return array_column(self::getCases(), 'value');
    }

    public static function pairedValues(): array
    {
        return array_map(fn($value) => [$value => $value], self::values());
    }

    protected static function merge(): array
    {
        return [];
    }


    protected static function getCases(): array
    {
        $cases = static::cases();
        foreach (self::merge() as $enum){
            $cases = array_merge(
                $cases,
                $enum::cases(),
            );
        }
        return $cases;
    }

}
