<?php

namespace MoveOn\Common\Traits;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Support\Facades\Response;
use Illuminate\Validation\ValidationException;

trait Validatable
{
    public function failedValidation(Validator $validator): void
    {
        $accept = request()->prefers(['application/json', 'text/html']);
        if ($accept == 'application/json') {
            $response = Response::json([
                "success" => false,
                "message" => "Validation failed!",
                "errors"  => $validator->errors(),
            ], 422);
            throw new ValidationException($validator, $response);
        }
        throw new ValidationException($validator);
    }
}
