<?php

namespace MoveOn\Subscription\Tests;

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use MoveOn\Subscription\MoveOnCommonProvider;
use \Orchestra\Testbench\TestCase as OrchestraTestBench;

abstract class TestCase extends OrchestraTestBench
{
    use DatabaseMigrations;

    /**
     * Set up
     */
    protected function setUp(): void
    {
        parent::setUp();
    }

    /**
     * Define environment setup.
     *
     * @param  Application $app
     * @return void
     */
    protected function getEnvironmentSetUp($app)
    {
        // Alter the testing timezone to America/Los_Angeles
         $app['config']->set('subscription.subscription_table_prefix', 'subscription');
    }

    /**
     * @param Application $app
     * @return array
     */
    protected function getPackageProviders($app)
    {
        return [MoveOnCommonProvider::class];
    }
}
