<?php

namespace MoveOn\EcommerceCli\Providers;

use Illuminate\Support\ServiceProvider;
use MoveOn\EcommerceCli\Console\Command\PackageMakeCommand;
use MoveOn\EcommerceCli\Console\Command\ProviderMakeCommand;
use MoveOn\EcommerceCli\Console\Command\ModuleProviderMakeCommand;
use MoveOn\EcommerceCli\Console\Command\AdminControllerMakeCommand;
use MoveOn\EcommerceCli\Console\Command\CustomerControllerMakeCommand;
use MoveOn\EcommerceCli\Console\Command\AdminRouteMakeCommand;
use MoveOn\EcommerceCli\Console\Command\CustomerRouteMakeCommand;
use MoveOn\EcommerceCli\Console\Command\MigrationMakeCommand;
use MoveOn\EcommerceCli\Console\Command\ModelMakeCommand;
use MoveOn\EcommerceCli\Console\Command\ModelProxyMakeCommand;
use MoveOn\EcommerceCli\Console\Command\ModelContractMakeCommand;
use MoveOn\EcommerceCli\Console\Command\RepositoryMakeCommand;
use MoveOn\EcommerceCli\Console\Command\SeederMakeCommand;
use MoveOn\EcommerceCli\Console\Command\MailMakeCommand;
use MoveOn\EcommerceCli\Console\Command\CommandMakeCommand;
use MoveOn\EcommerceCli\Console\Command\EventMakeCommand;
use MoveOn\EcommerceCli\Console\Command\ListenerMakeCommand;
use MoveOn\EcommerceCli\Console\Command\MiddlewareMakeCommand;
use MoveOn\EcommerceCli\Console\Command\RequestMakeCommand;
use MoveOn\EcommerceCli\Console\Command\NotificationMakeCommand;

class PackageGeneratorServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot(): void
    {
    }

    /**
     * Register services.
     *
     * @return void
     */
    public function register(): void
    {
        $this->registerCommands();
    }

    /**
     * Register the console commands of this package
     *
     * @return void
     */
    protected function registerCommands(): void
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                PackageMakeCommand::class,
                ProviderMakeCommand::class,
                ModuleProviderMakeCommand::class,
                AdminControllerMakeCommand::class,
                CustomerControllerMakeCommand::class,
                AdminRouteMakeCommand::class,
                CustomerRouteMakeCommand::class,
                MigrationMakeCommand::class,
                ModelMakeCommand::class,
                ModelProxyMakeCommand::class,
                ModelContractMakeCommand::class,
                RepositoryMakeCommand::class,
                SeederMakeCommand::class,
                MailMakeCommand::class,
                CommandMakeCommand::class,
                EventMakeCommand::class,
                ListenerMakeCommand::class,
                MiddlewareMakeCommand::class,
                RequestMakeCommand::class,
                NotificationMakeCommand::class,
            ]);
        }
    }
}