# MoveOn Ecommerce Cli
## 1. Introduction

MoveOn Ecommerce CLI will create a sample package for you with a single command

It packs in lots of demanding features that allows your business to scale in no time:

* Create package with a single command.

## 2. Requirements

* **PHP**: v8.0.0 or higher.
* **LARAVEL**: v9.0.0 or higher.

## 3. Installation

### Install with composer

Go to the root folder of **MoveOn** and run the following command

~~~php
composer require moveon/ecommerce-cli
~~~

> That's it, now just execute the project on your specified domain.

## 4. Summary

After setting up, you will see that there are list of package commands which help you to make your package creation smooth.

Below are the list of commands,

| S. No. | Commands                              | Info                                                                                                            | Required Arguments                     | Optional Arguments  |
| :----- |:--------------------------------------| :-------------------------------------------------------------------------------------------------------------- | :------------------------------------- | :------------------ |
| 01.    | package:make                          | [Create a new package.](#1-create-a-new-package)                                                                |  package-name                          | --force, --plain    |
| 02.    | package:make-admin-controller         | [Create a new admin controller.](#2-create-a-new-admin-controller)                                              |  controller-name, package-name         | --force             |
| 03.    | package:make-admin-route              | [Create a new admin routes file.](#3-create-a-new-admin-routes-file)                                            |  package-name                          | --force             |
| 04.    | package:make-customer-controller      | [Create a new customer controller.](#4-create-a-new-customer-controller)                                                |  controller-name, package-name         | --force             |
| 05.    | package:make-customer-route           | [Create a new customer routes file.](#5-create-a-new-customer-routes-file)                                              |  package-name                          | --force             |
| 06.    | package:make-model                    | [Create a new model class.](#6-create-a-new-model-class)                                                        |  model-name, package-name              | --force             |
| 07.    | package:make-model-proxy              | [Create a new model proxy class.](#7-create-a-new-model-proxy-class)                                            |  model-proxy-name, package-name        | --force             |
| 08.    | package:make-model-contract           | [Create a new model contract.](#8-create-a-new-model-contract)                                                  |  model-contract-name, package-name     | --force             |
| 09.    | package:make-migration                | [Create a new migration class.](#9-create-a-new-migration-class)                                                |  migration-name, package-name          |                     |
| 10.    | package:make-seeder                   | [Create a new seeder class.](#10-create-a-new-seeder-class)                                                     |  seeder-name, package-name             | --force             |
| 11.    | package:make-request                  | [Create a new request class.](#11-create-a-new-request-class)                                                   |  request-name, package-name            | --force             |
| 12.    | package:make-middleware               | [Create a new middleware class.](#12-create-a-new-middleware-class)                                             |  middleware-name, package-name         | --force             |
| 14.    | package:make-repository               | [Create a new repository class.](#14-create-a-new-repository-class)                                             |  repository-name, package-name         | --force             |
| 15.    | package:make-provider                 | [Create a new service provider class.](#15-create-a-new-service-provider-class)                                 |  provider-name, package-name           | --force             |
| 16.    | package:make-event                    | [Create a new event class.](#16-create-a-new-event-class)                                                       |  event-name, package-name              | --force             |
| 17.    | package:make-listener                 | [Create a new listener class.](#17-create-a-new-listener-class)                                                 |  listener-name, package-name           | --force             |
| 18.    | package:make-notification             | [Create a new notification class.](#18-create-a-new-notification-class)                                         |  notification-name, package-name       | --force             |
| 19.    | package:make-mail                     | [Create a new mail class.](#19-create-a-new-mail-class)                                                         |  mail-name, package-name               | --force             |
| 20.    | package:make-command                  | [Create a new command class.](#20-create-a-new-command-class)                                                   |  command-name, package-name            | --force             |
| 23.    | package:make-module-provider          | [Create a new module service provider class.](#23-create-a-new-module-service-provider-class)                   |  provider-name, package-name           | --force             |


**--force** : To overwrite the files

**--plain** : When you need only directory structure template, files are not included when this argument is passed

## 5. Usage

### Let's get started with our first command

#### 1. Create a new package

This command will generate all the necessary files which previously you create manually for your package.

~~~php
php artisan package:make MoveOn/TestPackage
~~~

For e.g., If you want to create a package which named as '**TestPackage**', then you need to use the command like this,

~~~php
php artisan package:make MoveOn/TestPackage
~~~

This will create whole directory structure for you automatically so that you don't want to do manually like registering routes, controller, etc.

##### New package with just directory structure

If you want to do things manually only need folder structures, then there is a optional argument known as '**plain**'. Below is the sample,

~~~php
php artisan package:make MoveOn/TestPackage --plain
~~~

##### New package with force command

If somehow folder or package is already present, then simple command won't work. So to overcome this problem we need to use force command.

~~~php
php artisan package:make MoveOn/TestPackage --force
~~~

#### 2. Create a new admin controller

This command will generate a new controller for your admin portion.

~~~php
php artisan package:make-admin-controller AdminTestController MoveOn/TestPackage
~~~

##### Create a new admin controller with force command

If controller is already present, then you need to use the force command.

~~~php
php artisan package:make-admin-controller AdminTestController MoveOn/TestPackage --force
~~~

#### 3. Create a new admin routes file

If you want to create an admin route, then you need to use this command and then register your routes file in the service provider i.e. '**MoveOn\TestPackage\Providers\TestPackageServiceProvider**'.

~~~php
php artisan package:make-admin-route MoveOn/TestPackage
~~~

##### Create a new admin routes file with force command

If admin routes file already present and you want to override this, then you need to use force command.

~~~php
php artisan package:make-admin-route MoveOn/TestPackage --force
~~~

#### 4. Create a new customer controller

This command will generate a new controller for your customer portion i.e. '**packages/MoveOn/TestPackage/src/Http/Controllers/Customer**'.

~~~php
php artisan package:make-customer-controller CustomerTestController MoveOn/TestPackage
~~~

##### Create a new customer controller with force command

If controller is already present, then you need to use the force command.

~~~php
php artisan package:make-customer-controller CustomerTestController MoveOn/TestPackage --force
~~~

#### 5. Create a new customer routes file

If you want to create a customer route, then you need to use this command and then register your routes file in the service provider i.e. 'MoveOn\TestPackage\Providers\TestPackageServiceProvider'.

~~~php
php artisan package:make-customer-route MoveOn/TestPackage
~~~

##### Create a new customer routes file with force command

If customer routes file already present and you want to override this, then you need to use force command.

~~~php
php artisan package:make-customer-route MoveOn/TestPackage --force
~~~

#### 6. Create a new model class

This command will create a following files,

* New model class in '**packages/MoveOn/TestPackage/src/Models**' directory.
* New model proxy class in '**packages/MoveOn/TestPackage/src/Models**' directory.
* New model contract in '**packages/MoveOn/TestPackage/src/Contracts**' directory.

~~~php
php artisan package:make-model TestModel MoveOn/TestPackage
~~~

##### Create a new model with force command

This command will overwrite all three files.

~~~php
php artisan package:make-model TestModel MoveOn/TestPackage --force
~~~

#### 7. Create a new model proxy class

This command will create a new model proxy class in '**packages/MoveOn/TestPackage/src/Models**' directory.

~~~php
php artisan package:make-model-proxy TestModelProxy MoveOn/TestPackage
~~~

##### Create a new model proxy with force command

If model proxy class already present then you can use force command for overwriting.

~~~php
php artisan package:make-model-proxy TestModelProxy MoveOn/TestPackage --force
~~~

#### 8. Create a new model contract

This command will create a new model contract in '**packages/MoveOn/TestPackage/src/Contracts**' directory.

~~~php
php artisan package:make-model-contract TestContract MoveOn/TestPackage
~~~

##### Create a new model contract with force command

If model contract already present then you can use force command for overwriting.

~~~php
php artisan package:make-model-contract TestDataGrid MoveOn/TestPackage --force
~~~

#### 9. Create a new migration class

This command will create a new migration class in '**packages/MoveOn/TestPackage/src/Database/Migrations**' directory.

~~~php
php artisan package:make-migration TestMigration MoveOn/TestPackage
~~~

#### 10. Create a new seeder class

This command will create a new seeder class in '**packages/MoveOn/TestPackage/src/Database/Seeders**' directory.

~~~php
php artisan package:make-seeder TestSeeder MoveOn/TestPackage
~~~

##### Create a new seeder class with force command

If seeder class already present then you can use force command for overwriting.

~~~php
php artisan package:make-seeder TestSeeder MoveOn/TestPackage --force
~~~

#### 11. Create a new request class

This command will create a new request class in '**packages/MoveOn/TestPackage/src/Http/Requests**' directory.

~~~php
php artisan package:make-request TestRequest MoveOn/TestPackage
~~~

##### Create a new request class with force command

If request class already present then you can use force command for overwriting.

~~~php
php artisan package:make-request TestRequest MoveOn/TestPackage --force
~~~

#### 12. Create a new middleware class

This command will create a new middleware class in '**packages/MoveOn/TestPackage/src/Http/Middleware**' directory.

~~~php
php artisan package:make-middleware TestMiddleware MoveOn/TestPackage
~~~

##### Create a new middleware class with force command

If middleware class already present then you can use force command for overwriting.

~~~php
php artisan package:make-middleware TestMiddleware MoveOn/TestPackage --force
~~~


#### 14. Create a new repository class

This command will create a new repository class in '**packages/MoveOn/TestPackage/src/Repositories**' directory.

~~~php
php artisan package:make-repository TestRepository MoveOn/TestPackage
~~~

##### Create a new repository with force command

If repository class already present then you can use force command for overwriting.

~~~php
php artisan package:make-repository TestRepository MoveOn/TestPackage --force
~~~

#### 15. Create a new service provider class

This command will create a new service provider class in '**packages/MoveOn/TestPackage/src/Providers**' directory.

~~~php
php artisan package:make-provider TestServiceProvider MoveOn/TestPackage
~~~

##### Create a new service provider with force command

If service provider class already present then you can use force command for overwriting.

~~~php
php artisan package:make-provider TestServiceProvider MoveOn/TestPackage --force
~~~

#### 16. Create a new event class

This command will create a new event class in '**packages/MoveOn/TestPackage/src/Events**' directory.

~~~php
php artisan package:make-event TestEvent MoveOn/TestPackage
~~~

##### Create a new event with force command

If event class already present then you can use force command for overwriting.

~~~php
php artisan package:make-event TestEvent MoveOn/TestPackage --force
~~~

#### 17. Create a new listener class

This command will create a new listener class in '**packages/MoveOn/TestPackage/src/Listeners**' directory.

~~~php
php artisan package:make-listener TestListener MoveOn/TestPackage
~~~

##### Create a new listener class with force command

If listener class already present then you can use force command for overwriting.

~~~php
php artisan package:make-listener TestListener MoveOn/TestPackage --force
~~~

#### 18. Create a new notification class

This command will create a new notification class in '**packages/MoveOn/TestPackage/src/Notifications**' directory.

~~~php
php artisan package:make-notification TestNotification MoveOn/TestPackage
~~~

##### Create a new notification with force command

If notification class already present then you can use force command for overwriting.

~~~php
php artisan package:make-notification TestNotification MoveOn/TestPackage --force
~~~

#### 19. Create a new mail class

This command will create a new mail class in '**packages/MoveOn/TestPackage/src/Mail**' directory.

~~~php
php artisan package:make-mail TestMail MoveOn/TestPackage
~~~

##### Create a new mail class with force command

If mail class already present then you can use force command for overwriting.

~~~php
php artisan package:make-mail TestMail MoveOn/TestPackage --force
~~~

#### 20. Create a new command class

This command will create a new command class in the '**packages/MoveOn/TestPackage/src/Console/Commands**' directory.

~~~php
php artisan package:make-command TestCommand MoveOn/TestPackage
~~~

##### Create a new command class with force command

If command class already present then you can use force command for overwriting.

~~~php
php artisan package:make-command TestCommand MoveOn/TestPackage --force
~~~

#### 23. Create a new module service provider class

This command will create a new module service provider class in '**packages/MoveOn/TestPackage/src/Providers**' directory.

~~~php
php artisan package:make-module-provider TestServiceProvider MoveOn/TestPackage
~~~

##### Create a new module service provider with force command

If module service provider class already present then you can use force command for overwriting.

~~~php
php artisan package:make-module-provider TestServiceProvider MoveOn/TestPackage --force
~~~