<?php

namespace MoveOn\EventBridgeSqsFifoQueue\Queue\Connectors;

use Aws\Sqs\SqsClient;
use Aws\EventBridge\EventBridgeClient;
use Illuminate\Queue\SqsQueue;

use Illuminate\Support\Arr;
use Illuminate\Queue\Connectors\ConnectorInterface;
use Illuminate\Support\Str;
use MoveOn\EventBridgeSqsFifoQueue\Queue\EventBridgePublisher;

class EventBridgeConnector implements ConnectorInterface
{
    /**
     * Establish a queue connection.
     *
     * @param  array  $config
     * @return \Illuminate\Contracts\Queue\Queue
     */
    public function connect(array $config)
    {
        $config = $this->getDefaultConfiguration($config);
        
        if (! empty($config['key']) && ! empty($config['secret'])) {
            $config['credentials'] = Arr::only($config, ['key', 'secret', 'token']);
        }
        $allowDelay   = (bool)Arr::pull($config, 'allow_delay', false);
        return new EventBridgePublisher(
            new EventBridgeClient(
                Arr::except($config, ['token'])
            ),
            $config['event_bus'],
            $config['global_source'],
            $config['after_commit'] ?? null
        );
    }

    /**
     * Get the default configuration for SQS.
     *
     * @param  array  $config
     * @return array
     */
    protected function getDefaultConfiguration(array $config)
    {
        return array_merge([
            'version' => 'latest',
            'http' => [
                'timeout' => 60,
                'connect_timeout' => 60,
            ],
        ], $config);
    }
}
