<?php

namespace MoveOn\EventBridgeSqsFifoQueue\Queue;

use Aws\Sqs\SqsClient;
use BadMethodCallException;
use Illuminate\Queue\Jobs\SqsJob;
use Illuminate\Support\Arr;
use InvalidArgumentException;
use Illuminate\Queue\SqsQueue;
use Illuminate\Mail\SendQueuedMailable;
use Illuminate\Notifications\SendQueuedNotifications;
use MoveOn\EventBridgeSqsFifoQueue\Contracts\Queue\Deduplicator;

class SqsConsumer extends SqsQueue
{
    /**
     * The queue name suffix.
     *
     * This property was made protected in Laravel 10x. The redefinition
     * here can be removed when support for < Laravel 10x is dropped.
     *
     * @var string
     */
    protected $suffix;
    
    

    /**
     * Create a new Amazon SQS queue instance.
     *
     * @param  \Aws\Sqs\SqsClient  $sqs
     * @param  string  $default
     * @param  string  $prefix
     * @param  string  $suffix
     * @param  bool  $dispatchAfterCommit
     * @param  string  $group
     * @param  string  $deduplicator
     * @param  bool  $allowDelay
     *
     * @return void
     */
    public function __construct(
        SqsClient $sqs,
        $default,
        $prefix = '',
        $suffix = '',
        $dispatchAfterCommit = false)
    {
        parent::__construct($sqs, $default, $prefix, $suffix, $dispatchAfterCommit);

        /**
         * The suffix property on SqsQueue was not made protected until Laravel 10x.
         * Since it is private on the parent class, the parent constructor will
         * not set the property on this class, so we must do it manually.
         */
        $this->suffix = $suffix;
    }

    /**
     * Pop the next job off of the queue.
     *
     * @param  string|null  $queue
     * @return \Illuminate\Contracts\Queue\Job|null
     */
    public function pop($queue = null)
    {
        $response = $this->sqs->receiveMessage([
            'QueueUrl' => $queue = $this->getQueue($queue),
            'AttributeNames' => ['ApproximateReceiveCount'],
        ]);
        
        if (! is_null($response['Messages']) && count($response['Messages']) > 0) {
            $message         = $response['Messages'][0];
            $body            = json_decode($message["Body"]);
            $detail          = (array)$body->detail;
            $detail["data"]  = (array)$detail["data"];
            $message["Body"] = json_encode($detail);
            
            return new SqsJob(
                $this->container, $this->sqs, $message,
                $this->connectionName, $queue
            );
        }
    }
}