# eventbridge-sqs-fifo-queue


## Install

Via Composer

``` bash
$ composer require moveon/eventbridge-sqs-fifo-queue
```

Once composer has been updated and the package has been installed, the service provider will need to be loaded.

#### Laravel 9.x, 10.x

This package uses auto package discovery. The service provider will automatically be registered.



## Configuration

#### Laravel 9.x, 10.x

open `config/queue.php` and add the following entry to the `connections` array.

        'eventbridge-publisher' => [
            'driver'        => 'eventbridge-publisher',
            'key'           => env('AWS_ACCESS_KEY_ID'),
            'secret'        => env('AWS_SECRET_ACCESS_KEY'),
            'event_bus'     => env('MESSAGE_BROKER_EVENT_BUS'),
            'global_source' => "moveon",
            'region'        => env('AWS_DEFAULT_REGION', 'us-east-1'),
            'after_commit'  => false,
        ],
        'primary-sqs' => [
            'driver' => 'sqs-consumer',
            'key' => env('AWS_ACCESS_KEY_ID'),
            'secret' => env('AWS_SECRET_ACCESS_KEY'),
            'prefix' => env('PRIMARY_SQS_FIFO_PREFIX'),
            'queue' => env('PRIMARY_SQS_QUEUE', 'default.fifo'),
            'suffix' => env('PRIMARY_SQS_SUFFIX'),
            'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
            'after_commit' => false,
        ],

Example .env file:

    AWS_ACCESS_KEY_ID=ABCDEFGHIJKLMNOPQRST
    AWS_SECRET_ACCESS_KEY=1a23bc/deFgHijKl4mNOp5qrS6TUVwXyz7ABCDef
    MESSAGE_BROKER_EVENT_BUS="moveon-test-event-bus"
    PRIMARY_SQS_FIFO_PREFIX=https://sqs.ap-southeast-1.amazonaws.com/097396358568
    PRIMARY_SQS_QUEUE=commerce-service-test2
    PRIMARY_SQS_SUFFIX=

#### Code Example

Job:

``` php
<?php

namespace App\Jobs;

use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use MoveOn\EventBridgeSqsFifoQueue\Jobs\BaseMessageBrokerJob;

class MessageBrokerJob extends BaseMessageBrokerJob
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, Batchable;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(
        public string $eventType,
        public string $message,
        public ?string $sourceSystem = "moveon",
        public ?string $component=null,
        public ?string $action=null,
        public ?string $entity=null,
        public ?string $entityId=null,
    )
    {
        parent::__construct();
        $this->onConnection("eventbridge-publisher");
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        echo $this->message;
    }
}

```

Usage:

``` php
            MessageBrokerJob::dispatch(
                CoreEventPublisherTypeEnum::COUNTRY_UPDATE,
                (new CountryMessageBrokerResource($country))->toJson(),
                "moveon", "country", CoreEventPublisherTypeEnum::COUNTRY_UPDATE,
                "country", $country->id
            );
```