<?php

namespace MoveOn\Inventory\Client\Facades;

use Illuminate\Support\Facades\Facade;
use MoveOn\Inventory\Client\Inventory as Client;

/**
 * @method static \MoveOn\Inventory\Client\Collection\Products search(array $body=[], string $response_format = "overview", string $version = "1", int $page = 1, int $perPage = 20))
 * @method static \MoveOn\Inventory\Client\Models\Product byUrl(string $url)
 * @method static \MoveOn\Inventory\Client\Models\Product byId(string $id)
 * @method static \MoveOn\Inventory\Client\Models\Product getDescriptionById(string $id)
 * @method static \MoveOn\Inventory\Client\Models\Product getReviewsById(string $id)
 *
 * @see \MoveOn\Inventory\Client\Inventory
 */
class Inventory extends Facade
{
    /**
     * Get the registered name of the component.
     *
     * @return string
     *
     * @throws \RuntimeException
     */
    protected static function getFacadeAccessor()
    {
        return Client::class;
    }
}
