<?php

namespace MoveOn\Inventory\Client\Models;

class Attribute extends Model
{
    /**
     * Attribute constructor
     *
     * @param string $id
     * @param string $name
     */
    public function __construct(string $id, string $name)
    {
        $this->attributes = [
            'id'     => $id,
            'name'   => $name,
            'values' => [],
        ];
    }

    /**
     * Set a attribute value.
     *
     * @param string $id
     * @param string $title
     * @param string|null $image
     * @param string|null $thumb
     * @param string|null $color
     * @param string|null $name
     *
     * @return self
     */
    public function setValue(string $id, string $title, ?string $image = null, ?string $thumb = null, ?string $color = null, ?string $name = null): self
    {
        $this->attributes['values'][] = [
            'id'    => $id,
            'title' => $title,
            'image' => $image,
            'thumb' => $thumb,
            'color' => $color,
            'name'  => $name,
        ];

        return $this;
    }
}
