<?php

namespace MoveOn\Inventory\Client\Models;

class Sku extends Model
{
    /**
     * Sku constructor
     *
     * @param string $id
     * @param string $props
     * @param float $price
     * @param int $stock
     */
    public function __construct(string $id, string $props, float $price, int $stock)
    {
        $this->attributes = [
            'id'             => $id,
            'props'          => $props,
            'price'          => $price,
            'stock'          => $stock,
            'special_price'  => null,
            'discount_price' => null,
            'min_qty'        => null,
            'limit_qty'      => null,
        ];
    }

    /**
     * @param $key
     * @param $value
     *
     * @return self
     */
    public function setAttribute($key, $value): self
    {
        if (!in_array($key, ['special_price', 'discount_price', 'min_qty', 'limit_qty'])) {
            return $this;
        }

        $this->attributes[$key] = $value;

        return $this;
    }
}
