<?php

namespace MoveOn\Inventory\Client\Facades;

use Illuminate\Support\Facades\Facade;
use MoveOn\Inventory\Client\Inventory as Client;

/**
 * @method static \MoveOn\Inventory\Client\Collection\Products search(array $filters)
 * @method static \MoveOn\Inventory\Client\Models\Product byLink(string $link, bool $refresh = false)
 * @method static \MoveOn\Inventory\Client\Models\Product byId(string $id, bool $refresh = false)
 * @method static \MoveOn\Inventory\Client\Inventory byVendorId(string $vendor, string $vPid, bool $refresh = false)
 * @method static \MoveOn\Inventory\Client\Collection\Freights fetchFreights(int $id, int $quantity, ?string $skuId = null)
 * @method static mixed fetchDomesticFee(int $id, int $quantity)
 * @method static array fetchReviews(int $id, int $page = 1)
 * @method static string|null fetchBody(int $id)
 *
 * @see \MoveOn\Inventory\Client\Inventory
 */
class Inventory extends Facade
{
    /**
     * Get the registered name of the component.
     *
     * @return string
     *
     * @throws \RuntimeException
     */
    protected static function getFacadeAccessor()
    {
        return Client::class;
    }
}
