<?php

namespace MoveOn\Inventory\Client\Helpers;

use MoveOn\Inventory\Client\Models\Category;

class CategoryTree
{
    /**
     * Get the tree.
     *
     * @var array
     */
    private array $categories;

    /**
     * Get category tree.
     *
     * @param array|null $categories
     */
    public function __construct(array $categories = [])
    {
        $this->categories = $categories;
    }

    /**
     * Make instance.
     *
     * @param ...$args
     *
     * @return static
     */
    public static function make(...$args): self
    {
        return new static(...$args);
    }

    /**
     * Get category tree.
     *
     * @return array
     */
    public function get(): array
    {
        return array_map(
            fn($cat) => $this->tree($cat['id'], $cat['name'], $cat['children'] ?? []),
            $this->categories
        );
    }

    /**
     * Make tree.
     *
     * @param int|string $id
     * @param string $name
     * @param array $children
     *
     * @return \MoveOn\Inventory\Client\Models\Category
     */
    private function tree($id, string $name, array $children = []): Category
    {
        $category = new Category($id, $name);
        foreach ($children as $child) {
            $category->addChild($this->tree($child['id'], $child['name'], $child['children'] ?? []));
        }

        return $category;
    }
}