<?php

namespace MoveOn\Inventory\Client\Models;

class Media extends Model
{
    /**
     * Media constructor
     *
     * @param string $image
     * @param string $thumbnail
     * @param string|null $title
     * @param string|null $video
     */
    public function __construct(string $image, string $thumbnail, ?string $title = null, ?string $video = null)
    {
        $this->attributes = [
            'image'     => $image,
            'thumbnail' => $thumbnail,
            'title'     => $title,
            'video'     => $video,
        ];
    }

    /**
     * @param string $title
     *
     * @return self
     */
    public function setTitle(string $title): self
    {
        $this->attributes['title'] = $title;

        return $this;
    }

    /**
     * @param string $video
     *
     * @return self
     */
    public function setVideo(string $video): self
    {
        $this->attributes['video'] = $video;

        return $this;
    }
}
