# Inventory Client

In this package you can get the products from MoveOn inventory.

## Installations

#### Add composer repositories

```json
"repositories": [
    {
        "type": "composer",
        "url": "https://composer.packages.moveon.work"
    }
],
```

### Install it on your project

```shell
composer require moveon/inventory-client
```

## Use it with Laravel

This package use auto discovery that's why it has support for laravel out of box. To make it work please update `.env`
file like below.

```dotenv
INVENTORY_CLIENT_APP_URL=https://inventory.ali2bd.com
INVENTORY_CLIENT_APP_ID=YOUR_APP_ID
INVENTORY_CLIENT_APP_SECRET=YOUR_APP_SECRET
```

For advanced config you can run `artisan vendor:publish --tag=inventory-config` to publish config file to your project.

You can use `Inventory` facades as like below.

```php
use MoveOn\Inventory\Client\Facades\Inventory;

// Search
$filters = [
    'keyword' => 'dress'
];

$results = Inventory::search($filters);

print_r($results->toArray());

// By Link
$link          = 'https://www.aliexpress.com/item/1005001339875854.html';
$productByLink = Inventory::byLink($link);

print_r($productByLink->toArray());

// By ID
$productById = Inventory::byId(2550650);

print_r($productByLink->toArray());

// By Vendor
$productByVendor = Inventory::byVendorId(1, 1005001339875854);

print_r($productByVendor->toArray());
```

## Use it with any framework

Install this package into your project by running `composer require moveon/inventory-client`. This package usage private
repository. Can be found here: https://composer.packages.moveon.work/

```php
require __DIR__ . '/../vendor/autoload.php';

$config = [
    'app_url' => 'https://inventory.ali2bd.com',
    'app_id'  => 'YOUR_API_APP_ID',
    'app_secret' => 'YOUR_API_APP_SECRET',
];

$inventory = new \MoveOn\Inventory\Client\Inventory($config);
```

### Search products

```php
$filters = [
    'keyword' => 'dress'
];

$results = $inventory->search($filters);

print_r($results->toArray());
```

### Get product by Link

```php
$link          = 'https://www.aliexpress.com/item/1005001339875854.html';
$productByLink = $inventory->byLink($link);

print_r($productByLink->toArray());
```

### Get product by ID

```php
$productByLink = $inventory->byId($id = 2550650);

print_r($productByLink->toArray());
```

### Get product by Vendor

```php
$productByVendor = $inventory->byVendorId($shop = 1, $id = 1005001339875854);

print_r($productByVendor->toArray());
```

### Get product freights

```php
$shipping = $inventory->fetchFreights($id = 1, $quantity = 4, $skuId = '1234');

print_r($shipping->toArray());
```

#### TODO:

- [ ] Write tests
