<?php

namespace MoveOn\Inventory\Client;

use Illuminate\Support\ServiceProvider;

class InventoryClientServiceProvider extends ServiceProvider
{
    /**
     * Register the package services.
     *
     * @return void
     * @throws \Exception
     */
    public function register()
    {
        if (!app()->configurationIsCached()) {
            $this->mergeConfigFrom(__DIR__ . '/../config/inventory.php', 'inventory');
        }

        $this->app->singleton(Inventory::class, function () {
            $config = config('inventory');

            return new Inventory($config);
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        if (app()->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/../config/inventory.php' => config_path('inventory.php'),
            ], 'inventory-config');
        }
    }
}
