<?php

namespace MoveOn\Inventory\Client\Models;

class Category extends Model
{
    /**
     * Category constructor
     *
     * @param int $id
     * @param string $name
     */
    public function __construct(int $id, string $name)
    {
        $this->attributes = [
            'id'   => $id,
            'name' => $name,
        ];
    }

    /**
     * Add child category.
     *
     * @param \MoveOn\Inventory\Client\Models\Category $category
     *
     * @return self
     */
    public function addChild(Category $category): self
    {
        $this->attributes['children'] = $category->toArray();

        return $this;
    }
}
