<?php

namespace MoveOn\Inventory\Client\Collection;

use MoveOn\Inventory\Client\Contracts\Model;

abstract class Collection
{
    /**
     * @var array
     */
    protected array $models = [];

    /**
     * Add a model.
     *
     * @param \MoveOn\Inventory\Client\Contracts\Model $model
     *
     * @return self
     */
    protected function add(Model $model): self
    {
        $this->models[] = $model;

        return $this;
    }

    /**
     * Get models as array.
     *
     * @return array
     */
    public function toArray(): array
    {
        return array_map(fn($model) => $model->toArray(), $this->models);
    }
}
