<?php

namespace MoveOn\InvMaskId;

class Mask
{
    /**
     * Mask string.
     *
     * @param string $string
     *
     * @return string|null
     */
    public static function mask(string $string): ?string
    {
        if (empty($string)) {
            return null;
        }

        $chars = str_split($string);

        $newChars = array_map(function ($char) {
            return self::strings()[$char] ?? $char;
        }, $chars);

        return implode('', $newChars);
    }

    /**
     * Unmask string.
     *
     * @param string $string
     *
     * @return string|null
     */
    public static function unmask(string $string): ?string
    {
        $chars = str_split($string);
        $algo  = array_flip(self::strings());

        $newChars = array_map(function ($char) use ($algo) {
            return $algo[$char] ?? $char;
        }, $chars);

        return implode('', $newChars);
    }

    /**
     * String maps.
     *
     * @return array
     */
    public static function strings(): array
    {
        return [
            'A' => 'P', 'B' => 'Q', 'C' => 'R', 'D' => 'S', 'E' => 'T',
            'F' => 'U', 'G' => 'V', 'H' => 'W', 'I' => 'X', 'J' => 'Y',
            'K' => 'Z', 'L' => 'A', 'M' => 'B', 'N' => 'C', 'O' => 'D',
            'P' => 'E', 'Q' => 'F', 'R' => 'G', 'S' => 'H', 'T' => 'I',
            'U' => 'J', 'V' => 'K', 'W' => 'L', 'X' => 'M', 'Y' => 'N', 'Z' => 'O',

            'a' => 'l', 'b' => 'm', 'c' => 'n', 'd' => 'o', 'e' => 'p',
            'f' => 'q', 'g' => 'r', 'h' => 's', 'i' => 't', 'j' => 'u',
            'k' => 'v', 'l' => 'w', 'm' => 'x', 'n' => 'y', 'o' => 'z',
            'p' => 'a', 'q' => 'b', 'r' => 'c', 's' => 'd', 't' => 'e',
            'u' => 'f', 'v' => 'g', 'w' => 'h', 'x' => 'i', 'y' => 'j', 'z' => 'k',

            '0' => '5', '1' => '6', '2' => '7', '3' => '8', '4' => '9',
            '5' => '0', '6' => '1', '7' => '2', '8' => '3', '9' => '4',
        ];
    }
}
