<?php

namespace MoveOn\InvMaskId\Tests;

use MoveOn\InvMaskId\Mask;
use PHPUnit\Framework\TestCase;

class MaskIdFeatureTests extends TestCase
{
    public function test_can_mask_string()
    {
        $string = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890abcdefghijklmnopqrstuvwxyz';
        $result = 'PQRSTUVWXYZABCDEFGHIJKLMNO6789012345lmnopqrstuvwxyzabcdefghijk';
        $mask   = Mask::mask($string);

        $this->assertSame($mask, $result);
    }

    public function test_can_unmask_string()
    {
        $string = 'PQRSTUVWXYZABCDEFGHIJKLMNO6789012345lmnopqrstuvwxyzabcdefghijk';
        $result = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890abcdefghijklmnopqrstuvwxyz';
        $unmask = Mask::unmask($string);

        $this->assertSame($unmask, $result);
    }

    public function test_can_result_same()
    {
        $string = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890abcdefghijklmnopqrstuvwxyz';
        $mask   = Mask::mask($string);
        $unmask = Mask::unmask($mask);

        $this->assertSame($unmask, $string);
    }
}
