<?php

namespace MoveOn\MetaField;

use Illuminate\Support\ServiceProvider;

class MoveOnMetaFieldProvider extends ServiceProvider
{
    public function boot()
    {
        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__.'/../config/metafield.php' => config_path('metafield.php'),
            ], 'mv-metafield-config');

            $this->publishes([
                __DIR__.'/../database/migrations/' => database_path('migrations')
            ], 'mv-metafield-migration');
        }

        $this->loadMigrationsFrom(__DIR__.'/../database/migrations');
    }

    public function register()
    {
        $this->mergeConfigFrom(__DIR__.'/../config/metafield.php', 'metafield');
    }
}
