<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use MoveOn\MetaField\Models\MetaField;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $metaField = new MetaField();
        Schema::create($metaField->getTable(), function (Blueprint $table) use ($metaField){
            $table->id();
            $table->integer('lock_version');
            $table->string('etag');
            $table->unsignedBigInteger('owner_id');
            $table->string('owner_type');
            $table->foreignId("region_id")->nullable();
            $table->foreign("region_id")
                  ->on($metaField->getRegionTableName())
                  ->references($metaField->getRegionRelationColumn())
                  ->nullOnDelete();
            $table->string('key')->index();
            $table->string('type');
            $table->json('value_json')->nullable();
            $table->string('value_string')->nullable();
            $table->bigInteger('value_integer')->nullable();
            $table->decimal('value_decimal', 23, 9)->nullable();
            $table->boolean('value_boolean')->nullable();
            $table->string('value_datetime')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->index(['owner_id', 'owner_type', 'key']);
            $table->index(['owner_id', 'owner_type', 'region_id', 'key']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists((new MetaField())->getTable());
    }
};
