<?php

namespace MoveOn\MetaField\Helpers;

use MoveOn\MetaField\Enum\MetaFieldTypesEnum;
use MoveOn\MetaField\Models\MetaField;

class MetaFieldHelper
{
    /**
     * Deserialize a MetaField collection
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphMany
     */
    public static function deserializeMetaFields(\Illuminate\Database\Eloquent\Collection $metaFields)
    {
        $result = [];
        foreach ($metaFields as $metafield) {
            $result[] = MetaFieldHelper::deserializeMetaField($metafield);
        }
        return $result;
    }

    /**
     * Deserialize a MetaField
     * 
     * @param  MetaField  $metaField
     *
     * @return array
     */
    public static function deserializeMetaField(MetaField $metaField): array
    {
        return [
            "id"    => $metaField->id,
            "key"   => $metaField->key,
            "type"  => $metaField->type,
            "value" => $metaField->{MetaFieldTypesEnum::VALUE_COLUMN[$metaField->type]}
        ];
    }

    /**
     * Get value from MetaFields collection by meta key
     * 
     * @param  \Illuminate\Database\Eloquent\Collection  $metaFields
     * @param  string  $key
     * @param  mixed|null  $default
     *
     * @return mixed
     */
    public static function getValue(
        \Illuminate\Database\Eloquent\Collection $metaFields,
        string $key, mixed $default = null
    ): mixed
    {
        $result = $default;
        foreach ($metaFields as $metafield) {
            if ($metafield->key === $key) {
                $result = MetaFieldHelper::deserializeMetaField($metafield)["value"];
                break;
            }
        }
        return $result;
    }
}