# MoveOn Meta Fields

The php library to get, store, edit & delete additional meta data.

## Installation

Add this to your composer.json file.

```json
{
  "repositories": [
    {
      "type": "composer",
      "url": "https://composer.packages.moveon.work"
    }
  ]
}
```

Then run this command in your terminal within your project directory.

```bash
composer require moveon/metafields
```

## Usage

```php
use MoveOn\MetaField\Facades\MetaField
```

#### Get queries
```php
MetaField::findByOwner(1, \App\Models\User::class);
MetaField::findByKey(1, \App\Models\User::class, 'key');
MetaField::findByRegion(1, \App\Models\User::class, 2);
MetaField::findByRegionKey(1, \App\Models\User::class, 2, 'key');
MetaField::findOwnerByValue('key', MetaFieldTypesEnum::BOOLEAN, true);
```

#### Create operation
```php
MetaField::create(int $owner_id, string $owner_type, string $key, string $type, mixed  $value, int $region_id = null);
//type - boolean
MetaField::create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::BOOLEAN, true);
//type - date_time
MetaField::create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::DATE_TIME, now());
//type - number_decimal
MetaField::create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::NUMBER_DECIMAL, 543543354.544520);
//type - number_integer
MetaField::create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::NUMBER_INTEGER, 9007199254740991);
//type - single_line_text_field
MetaField::create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::SINGLE_LINE_TEXT_FIELD, 'Laravel is awesome');
//type - json (value could be any type or null or json_encoded)
MetaField::create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::JSON, ["ingredient" => "flour", "amount" => 0.3]);
//type - volume
MetaField::create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::VOLUME, ['value' => 20.0, 'unit' => MetaFieldVolumeUnitsEnum::ML]);
//type - weight
MetaField::create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::WEIGHT, ['value' => 2.5, 'unit' => MetaFieldWeightUnitsEnum::KG]);
//type - dimension
MetaField::create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::DIMENSION, ['value' => 2.5, 'unit' => MetaFieldDimensionUnitsEnum::CM]);
```

#### Create multiple
```php
$data = [
            [
                'type'  => MetaFieldTypesEnum::BOOLEAN,
                'key'   => 'boolean_key',
                'value' => true
            ],
            [
                'type'  => MetaFieldTypesEnum::DATE_TIME,
                'key'   => 'date_time_key',
                'value' => now()
            ]
        ];
MetaField::createMultiple(4, 'App\Models\User', $data);
```

#### Update operation
```php
MetaField::update(int $id, int $owner_id, string $owner_type, string $key, string $type, mixed  $value, int $region_id = null);
```

#### Delete operation
```php
MetaField::delete(1);
MetaField::deleteByOwner(1, \App\Models\User::class);
```

## Necessary resources
_Model_ - `\MoveOn\MetaField\Models\MetaField::class`

_Enums_ -
* `\MoveOn\MetaField\Enum\MetaFieldTypesEnum`
* `\MoveOn\MetaField\Enum\MetaFieldVolumeUnitsEnum`
* `\MoveOn\MetaField\Enum\MetaFieldWeightUnitsEnum`
* `\MoveOn\MetaField\Enum\MetaFieldDimensionUnitsEnum`

## Publishable
```bash
php artisan vendor:pub --tag=mv-metafield-config
php artisan vendor:pub --tag=mv-metafield-migration
```

## Test
```bash
./vendor/bin/phpunit
```