<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use MoveOn\MetaField\Models\MetaField;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table((new MetaField())->getTable(), function (Blueprint $table) {
            $table->longText('value_longtext')->nullable()->after('value_string');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table((new MetaField())->getTable(), function (Blueprint $table) {
            $table->dropColumn('value_longtext');
        });
    }
};
