<?php

namespace MoveOn\MetaField\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use MoveOn\MetaField\Contracts\MetaField as MetaFieldContract;

class MetaField extends Model implements MetaFieldContract
{
    use SoftDeletes;

    protected $table;
    protected $guarded = ['id'];

    protected $casts = [
        'value_json' => 'json'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = config('meta_field.meta_field_table_name');
    }
}
