# MoveOn Meta Fields

The php library to get, store, edit & delete additional meta data.

## Installation

Add this to your composer.json file.

```json
{
  "repositories": [
    {
      "type": "composer",
      "url": "https://composer.packages.moveon.work"
    }
  ]
}
```

Then run this command in your terminal within your project directory.

```bash
composer require moveon/metafields
```

## Usage

```php
use MoveOn\MetaField\MetaFieldService;

$meta_field = app(MetaFieldService::class); // Or use dependency injection

// Get queries
$meta_field->findByOwner(1, \App\Models\User::class);
$meta_field->findByKey(1, \App\Models\User::class, 'key');
$meta_field->findByRegion(1, \App\Models\User::class, 2);
$meta_field->findByRegionKey(1, \App\Models\User::class, 2, 'key');
$meta_field->findOwnerByValue('key', MetaFieldTypesEnum::BOOLEAN, true);

// Create operation
$meta_field->create(int $owner_id, string $owner_type, string $key, string $type, mixed  $value, int $region_id = null);
//type - boolean
$meta_field->create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::BOOLEAN, true);
//type - date_time
$meta_field->create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::DATE_TIME, now());
//type - number_decimal
$meta_field->create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::NUMBER_DECIMAL, 543543354.544520);
//type - number_integer
$meta_field->create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::NUMBER_INTEGER, 9007199254740991);
//type - single_line_text_field
$meta_field->create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::SINGLE_LINE_TEXT_FIELD, 'Laravel is awesome');
//type - json (value could be any type or null or json_encoded)
$meta_field->create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::JSON, ["ingredient" => "flour", "amount" => 0.3]);
//type - volume
$meta_field->create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::VOLUME, ['value' => 20.0, 'unit' => MetaFieldVolumeUnitsEnum::ML]);
//type - weight
$meta_field->create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::WEIGHT, ['value' => 2.5, 'unit' => MetaFieldWeightUnitsEnum::KG]);
//type - dimension
$meta_field->create(1, \App\Models\User::class, 'key', MetaFieldTypesEnum::DIMENSION, ['value' => 2.5, 'unit' => MetaFieldDimensionUnitsEnum::CM]);

// Update operation
$meta_field->update(int $id, int $owner_id, string $owner_type, string $key, string $type, mixed  $value, int $region_id = null);

// Delete operation
$meta_field->delete(1);
```

## Necessary resources
_Model_ - `\MoveOn\MetaField\Models\MetaField::class`

_Enums_ -
* `\MoveOn\MetaField\Enum\MetaFieldTypesEnum`
* `\MoveOn\MetaField\Enum\MetaFieldVolumeUnitsEnum`
* `\MoveOn\MetaField\Enum\MetaFieldWeightUnitsEnum`
* `\MoveOn\MetaField\Enum\MetaFieldDimensionUnitsEnum`

## Publishable
```bash
php artisan vendor:pub --tag=mv-metafield-config
php artisan vendor:pub --tag=mv-metafield-migration
```

## Test
```bash
./vendor/bin/phpunit
```