<?php

namespace MoveOn\MetaField\Facades;

use Illuminate\Support\Facades\Facade;
use MoveOn\MetaField\Services as MetaFieldService;

/**
 * @method static \Illuminate\Database\Eloquent\Collection findByOwner(int $ownerId, string $ownerType)
 * @method static \Illuminate\Database\Eloquent\Collection findByKey(int $ownerId, string $ownerType, string $key)
 * @method static \Illuminate\Database\Eloquent\Collection findByRegion(int $ownerId, string $ownerType, int $regionId)
 * @method static \Illuminate\Database\Eloquent\Collection findByRegionKey(int $ownerId, string $ownerType, int $regionId, string $key)
 * @method static \Illuminate\Database\Eloquent\Collection findOwnerByValue(string $key, string $type, mixed $value)
 * @method static mixed create(int $ownerId, string $ownerType, string $key, string $type, mixed $value, int $regionId = null)
 * @method static mixed createMultiple(int $ownerId, string $ownerType, array $kvPair, int $regionId = null)
 * @method static mixed update(int $id, int $ownerId, string $ownerType, string $key, string $type, mixed $value, int $regionId = null)
 * @method static mixed delete(int $id)
 * @method static mixed deleteByOwner(int $ownerId, string $ownerType)
 *
 * @see \MoveOn\MetaField\MetaFieldService
 */
class MetaField extends Facade
{
    /**
     * Get the registered name of the component.
     *
     * @return string
     *
     * @throws \RuntimeException
     */
    protected static function getFacadeAccessor()
    {
        return MetaFieldService::class;
    }
}
